﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports Microsoft.VisualBasic.FileIO

Public Class CopyFilePanel
    Inherits FileSystemSample.TaskPanelBase

#Region " Windows 窗体设计器生成的代码 "

    Private Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub


    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.AutoSize = False
        Me.DescriptionTextBox.Location = New System.Drawing.Point(7, 20)
        Me.DescriptionTextBox.Multiline = True
        Me.DescriptionTextBox.Size = New System.Drawing.Size(568, 61)
        Me.DescriptionTextBox.Text = "My.Computer.FileSystem.CopyFile copies from one location to another.  It exposes " & _
            "functionality to rename file during the copy, show the Windows Shell dialog, and" & _
            " overwrite the existing file in the target directory, if any."
        '
        'ExececuteMethodButton
        '
        '
        'ResetValuesButton
        '
        '
        'CopyFilePanel
        '
        Me.Name = "CopyFilePanel"

    End Sub

#End Region


    Private Shared panelInstance As CopyFilePanel
    Friend WithEvents sourceFileChooser As New FileChooser()
    Friend WithEvents targetChooser As New DirectoryChooser()
    Friend WithEvents newNameTextBox As New TextBox()
    Friend WithEvents overWriteComboBox As New ComboBox()
    Friend WithEvents showUIComboBox As New ComboBox()
    Friend WithEvents onUserCancelComboBox As New ComboBox()

    ''' <summary>
    ''' 返回此面板的全局实例。
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As CopyFilePanel
        If (panelInstance Is Nothing) Then
            panelInstance = New CopyFilePanel()
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板，并在该面板中为 copyDirectory 的每个参数中添加控件
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub CopyFilePanel_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("sourceFileName", sourceFileChooser)
        MyBase.AddParameter("destinationFileName", targetChooser)
        MyBase.AddParameter("showUI", showUIComboBox)
        MyBase.AddParameter("onUserCancel", onUserCancelComboBox)
    End Sub

    ''' <summary>
    ''' 当用户选择某一文件名后，会自动将 newName 参数设置为该选定文件名。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub sourceFileChooser_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles sourceFileChooser.Leave
        If (Me.sourceFileChooser.Filename <> String.Empty) Then
            Me.newNameTextBox.Text = System.IO.Path.GetFileName(Me.sourceFileChooser.Filename)
        End If
    End Sub


    ''' <summary>
    ''' 用所有可能的参数值初始化每个控件
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.CopyFile("

        Me.sourceFileChooser.Reset()
        Me.targetChooser.Reset()
        Me.newNameTextBox.Text = String.Empty

        overWriteComboBox.Items.AddRange(New String() {"True", "False"})
        overWriteComboBox.AutoSize = True
        overWriteComboBox.SelectedItem = "False"

        showUIComboBox.Items.AddRange(New String() {"True", "False"})
        showUIComboBox.AutoSize = True
        showUIComboBox.SelectedItem = "False"

        onUserCancelComboBox.Items.AddRange(New String() {"Do Nothing", "Throw Exception"})
        onUserCancelComboBox.AutoSize = True
        onUserCancelComboBox.SelectedItem = "Throw Exception"
    End Sub

    ''' <summary>
    ''' 使用指定的参数复制文件。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        Try
            My.Computer.FileSystem.CopyFile( _
                                    sourceFileName:=Me.sourceFileChooser.Filename, _
                                    destinationFileName:=Me.targetChooser.Directory, _
                                    showUI:=CType(UIOption.Parse(GetType(UIOption), CType(Me.showUIComboBox.SelectedItem, String)), UIOption), _
                                    onUserCancel:=ParseUICancelOption(Me.onUserCancelComboBox))
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    Private Sub ResetValuesButton_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub
End Class
